# Bitcoin Puzzle 71 Client / Клиент для Bitcoin Puzzle 71

## 📋 Requirements / Требования

### 🖥️ Hardware Requirements / Аппаратные требования
- **GPU**: NVIDIA with CUDA Compute Capability 6.0+ / NVIDIA с поддержкой CUDA Compute Capability 6.0+
- **Memory**: Minimum 4GB VRAM / Минимум 4GB видеопамяти

### 🔧 Software Requirements / Программные требования
- **OS**: Linux (Ubuntu 18.04+ / Debian 10+) 
- **Compiler**: **ONLY g++-9** / **ТОЛЬКО g++-9** (required / обязательно!)
- **CUDA**:
  - For RTX 4090: CUDA 12.0+ / Для RTX 4090: CUDA 12.0+
  - For other cards: CUDA 11.0+ / Для других карт: CUDA 11.0+
- **Drivers**: NVIDIA driver 470+ / Драйверы NVIDIA 470+

## 🚀 Compiling VanitySearch / Компиляция VanitySearch

### 1. Install Compiler / Установка компилятора


# Install g++-9 (REQUIRED this version!) / Установка g++-9 (ОБЯЗАТЕЛЬНО эта версия!)
sudo apt update
sudo apt install g++-9 build-essential -y


2. Install CUDA / Установка CUDA
bash
# For RTX 4090 (CUDA 12.0+): / Для RTX 4090 (CUDA 12.0+):
wget https://developer.download.nvidia.com/compute/cuda/12.0.0/local_installers/cuda_12.0.0_525.60.13_linux.run
sudo sh cuda_12.0.0_525.60.13_linux.run

# For other cards (CUDA 11.0+): / Для других карт (CUDA 11.0+):
wget https://developer.download.nvidia.com/compute/cuda/11.8.0/local_installers/cuda_11.8.0_520.61.05_linux.run
sudo sh cuda_11.8.0_520.61.05_linux.run


3. Environment Setup / Настройка окружения
bash
# Add to ~/.bashrc / Добавить в ~/.bashrc
export PATH=/usr/local/cuda/bin:$PATH
export LD_LIBRARY_PATH=/usr/local/cuda/lib64:$LD_LIBRARY_PATH

# Apply changes / Применить изменения
source ~/.bashrc


4. Compile VanitySearch / Компиляция VanitySearch
bash
# Go to VanitySearch folder / Перейдите в папку с VanitySearch
cd VanitySearch

# COMPILE FOR ALL CARDS: / КОМПИЛЯЦИЯ ДЛЯ ВСЕХ КАРТ:
make all

# Check binary / Проверка бинарника
./vanitysearch --help
IMPORTANT: Compilation works ONLY with g++-9!
ВАЖНО: Компиляция работает ТОЛЬКО с g++-9!

🎮 Running the Client / Запуск клиента

# Run client / Запуск клиента
./client

Setup Steps / Шаги настройки:
Server URL: Press Enter for default pool / Нажмите Enter для пула по умолчанию

Client ID: Unique name (minimum 8 characters) / Уникальное имя (минимум 8 символов)

Wallet Address: Your Bitcoin address for rewards / Ваш Bitcoin-адрес для получения наград

📊 Client Interface / Интерфейс клиента
After launch you'll see status display:
После запуска вы увидите статус-дисплей:


GPU  Status    Speed      Chunk ID    Range                                  Keys Checked       Progress               Time        Params
------------------------------------------------------------------------------------------------------------------------------------------------
0    [ON]      125.4M/s   42          20000000000000000-2000000000000ffff    1,245,678,900      ############.... 62.5%  05:23     auto-config
1    [ON]      98.2M/s    43          20000000000010000-2000000000001ffff    987,654,321       ##########...... 50.0%  03:45     auto-config


🛠️ Troubleshooting / Решение проблем
Compilation Error / Ошибка компиляции

# Check compiler version / Проверьте версию компилятора
g++-9 --version

# Should be: g++-9 (Ubuntu 9.4.0-1ubuntu1~18.04) 9.4.0
# Должно быть: g++-9 (Ubuntu 9.4.0-1ubuntu1~18.04) 9.4.0
GPU Not Detected / Не видит GPU

# Check drivers / Проверка драйверов
nvidia-smi

# Reload drivers / Перезагрузка драйверов
sudo modprobe -r nvidia_uvm nvidia_drm nvidia_modeset nvidia
sudo modprobe nvidia nvidia_modeset nvidia_drm nvidia_uvm
CUDA Error / Ошибка CUDA
bash

# Check CUDA version / Проверка версии CUDA
nvcc --version
⚡ Management / Управление
Automatic operation: Client gets tasks automatically / Клиент сам получает задания

Graceful shutdown: Ctrl+C for proper shutdown / Ctrl+C для корректного завершения

Real-time status: Updates every 2 seconds / Обновление каждые 2 секунды

🔒 Features / Особенности
All GPU support: Automatic parameter detection / Автоматическое определение параметров

Security: Proof-of-Work and signed tasks / Proof-of-Work и подписанные задания

Fault tolerance: Auto-return of chunks on errors / Авто-возврат чанков при ошибках

Good luck with the search! / Удачи в поиске! 🚀

# VanitySearch PuzzleNet Edition

## License
GPLv3 - For source code access, please contact PuzzleNet administration.
